﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Threading;

namespace SWAT_USB_App
{
    public partial class Drivers_Form : Form
    {
        private static List<Process> toInstall = new List<Process>();
        private static List<RadioButton> formRadioButton = new List<RadioButton>();
        public Drivers_Form()
        {
            InitializeComponent();
            try
            {
                bool modelFound = false;
                Debug.appendText("Driver form initializing");
                if (SettingsParser.driverCheckForMatchingModel)
                    Initialization.GetModelNumber();
                // Draws the form with a radiobutton for each driver specified in the text file
                // Location placeholder 
                int nextXLocation = 6, nextYLocation = 19;
                // Updates the groupbox size to hold all the radiobuttons
                this.groupBox_DriverList.Size = new Size(SettingsParser.driverFormWidth - 31, 19 + SettingsParser.DriversList.Count() * 23);
                // Updates the window size to hold all the radiobuttons + buttons
                this.Size = new Size(SettingsParser.driverFormWidth, 101 + SettingsParser.DriversList.Count() * 23);
                formRadioButton.Clear();
                // Adds a radiobutton for each software item, adds rdoBtn to list formRadioButton
                for (int i = 0; i < SettingsParser.DriversList.Count(); i++)
                {
                    RadioButton rdoBtn = new RadioButton();
                    rdoBtn.Name = "rdo_" + SettingsParser.DriversList[i].Name;
                    rdoBtn.AutoSize = true;
                    // Removes the brackets from the name
                    rdoBtn.Text = SettingsParser.DriversList[i].Name;
                    rdoBtn.Location = new Point(nextXLocation, nextYLocation);
                    // Increments the location placeholder for the next radiobutton
                    nextYLocation += 23;
                    this.groupBox_DriverList.Controls.Add(rdoBtn);
                    formRadioButton.Add(rdoBtn);
                    if (SettingsParser.driverCheckForMatchingModel)
                        // If model is detected, check the correct entry
                        if (SettingsParser.DriversList[i].Name.ToLower() == Initialization.computerModel.ToLower() && modelFound == false)
                        {
                            modelFound = true;
                            rdoBtn.Checked = true;
                        }
                }
                if (SettingsParser.driverCheckForMatchingModel)
                {
                    if (modelFound == true)
                    {
                        MessageBox.Show("Drivers were found for this computer.\n" +
                            "Press OK to continue then OK to install drivers.");
                    }
                    else
                    {
                        MessageBox.Show("Drivers were not found for this computer.\n" +
                            "Please go to the manufacturer's site and manually\n" +
                            "download the drivers for this computer.");
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.appendText("Exception Thrown: " + ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }
        private void updateToInstallList()
        {
            try
            {
                Debug.appendText("Updating list of processes to run from list of drivers checked");
                toInstall.Clear();
                // Updates list toInstall with processes for each software checked
                for (int i = 0; i < formRadioButton.Count(); i++)
                {
                    if (formRadioButton[i].Checked)
                    {
                        string[] temp = null;
                        // Pulls the setup locations
                        for (int j = 0; j < SettingsParser.DriversList.Count(); j++)
                            if (SettingsParser.DriversList[j].Name == formRadioButton[i].Text)
                            {
                                temp = SettingsParser.DriversList[j].SetupFileLocation;
                                break;
                            }
                        for (int j = 0; j < temp.Count(); j += 2)
                        {
                            Process proc = new Process();
                            proc.StartInfo.FileName = Initialization.pathToSWATDrive + temp[j];
                            proc.StartInfo.Arguments = temp[j + 1];
                            toInstall.Add(proc);
                        }
                    }
                }
            }
            catch (Exception e)
            {
                Debug.appendText("Exception Thrown: " + e.ToString());
                MessageBox.Show(e.ToString());
            }
        }
        private void startDriverInstallation(List<Process> toInstall, int ID)
        {
            Debug.appendText("Starting to install drivers from list of processes");
            try
            {
                //this.WindowState = FormWindowState.Minimized;
                // Goes through list toInstall and runs each process after the previous one ends
                int tempID = ID;
                if (tempID < toInstall.Count)
                {
                    Debug.appendText("Running setup " + toInstall[ID].StartInfo.FileName + " with arguments " + toInstall[ID].StartInfo.Arguments);
                    toInstall[ID].Start();
                    while (!toInstall[ID].HasExited)
                    {
                        // Waits for installer to finish before starting the next one
                        Thread.Sleep(3000);
                    }
                    if (toInstall[ID].HasExited)
                    {
                        Debug.appendText("Setup is detected as finished, running next setup");
                        tempID++;
                        startDriverInstallation(toInstall, tempID);
                    }
                }
                //this.WindowState = FormWindowState.Normal;
            }
            catch (Exception e)
            {
                Debug.appendText("Exception Thrown: " + e.ToString());
                MessageBox.Show(e.ToString());
            }
        }
        private void btn_Driver_Ok_Click(object sender, EventArgs e)
        {
            updateToInstallList();
            startDriverInstallation(toInstall, 0);
            this.Close();
        }
        private void btn_Driver_Cancel_Click(object sender, EventArgs e)
        {
            Debug.appendText("Closing driver form");
            this.Close();
        }
    }
}
